/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.sdmshoprework.common.integration.FTBQuests;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftbquests.net.DisplayRewardToastMessage;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.reward.Reward;
import dev.ftb.mods.ftbquests.quest.reward.RewardType;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.sixik.sdmshoprework.SDMShopR;
import net.sixik.sdmshoprework.SDMShopRework;

public class MoneyReward
extends Reward {
    public static RewardType TYPE;
    public long value = 1L;
    public int randomBonus = 0;

    public MoneyReward(Quest q) {
        super(q);
    }

    public RewardType getType() {
        return TYPE;
    }

    public void writeData(CompoundTag nbt) {
        nbt.m_128356_("ftb_money", this.value);
        if (this.randomBonus > 0) {
            nbt.m_128405_("random_bonus", this.randomBonus);
        }
    }

    public void readData(CompoundTag nbt) {
        this.value = nbt.m_128454_("ftb_money");
        this.randomBonus = nbt.m_128451_("random_bonus");
    }

    public void writeNetData(FriendlyByteBuf buf) {
        super.writeNetData(buf);
        buf.m_130103_(this.value);
        buf.m_130130_(this.randomBonus);
    }

    public void readNetData(FriendlyByteBuf buf) {
        super.readNetData(buf);
        this.value = buf.m_130258_();
        this.randomBonus = buf.m_130242_();
    }

    public void getConfig(ConfigGroup config) {
        super.getConfig(config);
        config.addLong("value", this.value, v -> {
            this.value = v;
        }, 1L, 1L, Long.MAX_VALUE).setNameKey("ftbquests.reward.sdmshop.money");
        config.addInt("random_bonus", this.randomBonus, v -> {
            this.randomBonus = v;
        }, 0, 0, Integer.MAX_VALUE).setNameKey("ftbquests.reward.random_bonus");
    }

    public void claim(ServerPlayer player, boolean notify) {
        long money = SDMShopR.getMoney((Player)player);
        long added = this.value + (long)player.f_19853_.f_46441_.m_188503_(this.randomBonus + 1);
        SDMShopR.setMoney((Player)player, money + added);
        if (notify) {
            new DisplayRewardToastMessage(this.id, (Component)Component.m_237113_((String)SDMShopRework.moneyString(added)), Icon.getIcon((String)"sdmshoprework:textures/icons/money.png")).sendTo(player);
        }
    }

    public Component getAltTitle() {
        if (this.randomBonus > 0) {
            return Component.m_237113_((String)(SDMShopRework.moneyString(this.value) + " - " + SDMShopRework.moneyString(this.value + (long)this.randomBonus))).m_130940_(ChatFormatting.GOLD);
        }
        return Component.m_237113_((String)SDMShopRework.moneyString(this.value));
    }

    public String getButtonText() {
        if (this.randomBonus > 0) {
            return this.randomBonus + "-" + Long.toUnsignedString(this.value + (long)this.randomBonus);
        }
        return Long.toUnsignedString(this.value);
    }
}

